/*
 * Decompiled with CFR 0.152.
 */
package ags.ui.graphics;

import java.awt.Color;
import java.awt.image.BufferedImage;

public class Convert {
    private static final int[] hgrDhgr = new int[]{0, 9, 6, 15, 0, 3, 12, 15};
    static int[][] hgrToDhgr = new int[256][256];
    static int[][] hgrToDhgrBW = new int[256][256];
    static int[] textOffset;
    static int[] hiresOffset;

    public static void convertDHGRtoBWRaster(byte[] source, BufferedImage output) {
        boolean doubleHeight = false;
        if (output.getHeight() == 384) {
            doubleHeight = true;
        }
        for (int y = 0; y < 192; ++y) {
            int rowAddress = hiresOffset[y];
            for (int x = 0; x < 40; ++x) {
                int b1 = 0x7F & source[rowAddress + 8192 + x];
                int b2 = 0x7F & source[rowAddress + x];
                int dhgrWord = b1 << 7 | b2;
                for (int i = 0; i < 14; ++i) {
                    int color;
                    boolean isOn = (dhgrWord & 1) == 1;
                    int xx = x * 14 + i;
                    int n = color = isOn ? Color.WHITE.getRGB() : Color.BLACK.getRGB();
                    if (doubleHeight) {
                        output.setRGB(xx, y * 2, color);
                        output.setRGB(xx, y * 2 + 1, color);
                    } else {
                        output.setRGB(xx, y, color);
                    }
                    dhgrWord >>= 1;
                }
            }
        }
    }

    public static void convertHGRtoBWRaster(byte[] source, BufferedImage output) {
        boolean doubleHeight = false;
        if (output.getHeight() == 384) {
            doubleHeight = true;
        }
        for (int y = 0; y < 192; ++y) {
            int rowAddress = hiresOffset[y];
            for (int x = 0; x < 40; ++x) {
                int b1 = 0xFF & source[rowAddress + x];
                int b2 = 0xFF & source[rowAddress + x + 1];
                int dhgrWord = hgrToDhgr[b1][b2];
                for (int i = 0; i < 14; ++i) {
                    int color;
                    boolean isOn = (dhgrWord & 1) == 1;
                    int xx = x * 14 + i;
                    int n = color = isOn ? Color.WHITE.getRGB() : Color.BLACK.getRGB();
                    if (doubleHeight) {
                        output.setRGB(xx, y * 2, color);
                        output.setRGB(xx, y * 2 + 1, color);
                    } else {
                        output.setRGB(xx, y, color);
                    }
                    dhgrWord >>= 1;
                }
            }
        }
    }

    public static int calculateHiresOffset(int y) {
        return Convert.calculateTextOffset(y >> 3) + ((y & 7) << 10);
    }

    public static int calculateTextOffset(int y) {
        return ((y & 7) << 7) + 40 * (y >> 3);
    }

    protected static int byteDoubler(byte b) {
        int num = (b & 0x40) << 6 | (b & 0x20) << 5 | (b & 0x10) << 4 | (b & 8) << 3 | (b & 4) << 2 | (b & 2) << 1 | b & 1;
        return num | num << 1;
    }

    static {
        for (int bb1 = 0; bb1 < 256; ++bb1) {
            for (int bb2 = 0; bb2 < 256; ++bb2) {
                int h1 = (bb1 & 0x80) >> 5;
                int h2 = (bb2 & 0x80) >> 5;
                int b1 = bb1 & 0x7F;
                int b2 = bb2 & 0x7F;
                int dhgrWord = 0;
                dhgrWord |= hgrDhgr[b1 & 3 | h1];
                dhgrWord |= hgrDhgr[(b1 >>= 2) & 3 | h1] << 4;
                dhgrWord |= hgrDhgr[(b1 >>= 2) & 3 | h1] << 8;
                dhgrWord |= (3 & hgrDhgr[(b1 >>= 2) & 1 | (b2 & 1) << 1 | h1]) << 12;
                dhgrWord |= (0xC & hgrDhgr[b1 & 1 | (b2 & 1) << 1 | h2]) << 12;
                dhgrWord |= hgrDhgr[(b2 >>= 1) & 3 | h2] << 16;
                dhgrWord |= hgrDhgr[(b2 >>= 2) & 3 | h2] << 20;
                Convert.hgrToDhgr[bb1][bb2] = dhgrWord |= hgrDhgr[(b2 >>= 2) & 3 | h2] << 24;
                Convert.hgrToDhgrBW[bb1][bb2] = Convert.byteDoubler((byte)bb1) | Convert.byteDoubler((byte)bb2) << 14;
            }
        }
        textOffset = new int[192];
        hiresOffset = new int[192];
        for (int i = 0; i < 192; ++i) {
            Convert.textOffset[i] = Convert.calculateTextOffset(i >> 3);
            Convert.hiresOffset[i] = Convert.calculateHiresOffset(i);
        }
    }
}

